<#
.SYNOPSIS
Returns Installed Applications as displayed in the Control Panel

.DESCRIPTION
Returns objects containng propeties of installed Applications to determine how to uninstall

.EXAMPLE
An example

.NOTES
Credit: https://social.technet.microsoft.com/Forums/windowsserver/en-US/1fd035f3-a170-4721-a6b5-d4809ca2e39d/getting-list-of-installed-software-that-matches-control-panels-addremove-programs-or-programs?forum=winserverpowershell
#>
function Get-InstalledApplications {
    $unistallPath = "\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\"
    $unistallWow6432Path = "\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\"
      $retArray = 
          @(
          if (Test-Path "HKLM:$unistallWow6432Path" ) { Get-ChildItem "HKLM:$unistallWow6432Path"}
          if (Test-Path "HKLM:$unistallPath" ) { Get-ChildItem "HKLM:$unistallPath" }
          if (Test-Path "HKCU:$unistallWow6432Path") { Get-ChildItem "HKCU:$unistallWow6432Path"}
          if (Test-Path "HKCU:$unistallPath" ) { Get-ChildItem "HKCU:$unistallPath" }
          ) |
          ForEach-Object { Get-ItemProperty $_.PSPath } |
          Where-Object {
            $_.DisplayName -and !$_.SystemComponent -and !$_.ReleaseType -and !$_.ParentKeyName -and ($_.UninstallString -or $_.NoRemove)
          } |
          Sort-Object DisplayName |
          Select-Object DisplayName, UninstallString
    return $retArray
  }

<#
.SYNOPSIS
Returns the Installed Application as displayed in the Control Panel

.DESCRIPTION
Returns an object with the properties of the Installed Application as displayed in the Control Panel or $null if the appliation is not installed

.PARAMETER DisplayName
DisplayName of the application 

.EXAMPLE
$app = Get-InstalledApplication "Microsoft OneDrive"

.NOTES
General notes
#>
  function Get-InstalledApplication {
    param(
        [Parameter(Mandatory = $true)][ValidateNotNullOrEmpty()][string] $DisplayName
    )
      return Get-InstalledApplications | Where-Object {$_.DisplayName -eq $DisplayName}
  }

  Export-ModuleMember -Function Get-InstalledApplications
  Export-ModuleMember -Function Get-InstalledApplication