
function Reboot {
    cmd /c "shutdown -r -t 5 -f"
}


function Commit-Registry{
    param(
        [string] $key,
        [string] $value
    )
    start-process uwfmgr -ArgumentList registry,commit,$key,$value -Wait
}

function Set-Shell {
    param(
        [string] $value
    )
    $key = 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon'
    Set-ItemProperty $key -Name Shell -Value $value
    Commit-Registry $key $value
}


function Set-DiskAccess {
    param(
        [Int] $value
    )

    $path = "HKCU:\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer";
    $name = "NoViewOnDrive";

    Set-ItemProperty -Path $path -Name $name -Value $value;
    Commit-Registry -key $path -value $name
    
}

function Set-Freeze {
    param(
        [bool] $freeze
    )

    $path = "HKLM:\SOFTWARE\Panacea\Updater";
    $name= "Freeze"
    $value = if($freeze) {1} else {0}

    Set-ItemProperty $path -name $name -value $value;

}

function Set-UWF {
    param(
        [bool] $on
    )


    if($on){
        start-process uwfmgr.exe -ArgumentList "filter","enable" -wait
    }else{
        start-process uwfmgr.exe -ArgumentList "filter","disable" -wait
    }
}
function Desktop-Mode{
   Set-Shell "explorer.exe"
   Disable-KeyboardFilter
   Set-DiskAccess 0
   Set-UWF $false
   Set-Freeze -freeze $false
   Reboot
}

function Kiosk-Mode{
   Set-Shell "eshell.exe"
   Set-UWF $false
   Set-Freeze -freeze $true
   Enable-KeyboardFilter
   Reboot
}

function Presentation-LiteMode {
    Set-Shell "eshell.exe"
    Set-UWF $false
    Disable-KeyboardFilter
    Reboot
 }
function Presentation-Mode {
   Set-Shell "eshell.exe"
   Set-UWF $false
   Set-Freeze -freeze $false
   Enable-KeyboardFilter
   Reboot
}


function Quick-Desktop{
    cmd /c "$env:SystemDrive\scripts\desktop.cmd"
}

<#



.SYNOPSIS

Allows an IBT to be configured to different standard mode. Which works best. These modes are Demo, Kiosk and Desktop

.DESCRIPTION

Configuring the IBT for different modes allows a user to do specific tasks.

.PARAMETER mode


.EXAMPLE

Set-IBTMode Desktop

#>
function Set-IBTMode {
    param(
        [Parameter(Mandatory = $true)][ValidateSet("Desktop","Kiosk","Demo","Demo-Lite","Quick")][string] $mode
    )

    switch($mode.ToLower())
    {

        "desktop"{
            Desktop-Mode
        }

        "kiosk"{
            Kiosk-Mode
        }

        "demo-lite"{
            Presentation-LiteMode
        }

        "demo"{
            Presentation-Mode
        }

        "quick" {
            Quick-Desktop
        }

        default {
            throw [System.ArgumentException] "Incorrect IBT mode $mode, only Desktop, Kiosk and Demo are allowed"
        }
    }


}


Export-ModuleMember -Function Set-IBTMode,Reboot

