<#
.SYNOPSIS
Short description

.DESCRIPTION
Long description

.PARAMETER namespace
Parameter description

.EXAMPLE
An example
 $myLogger = Get-Logger <Namespace> [LogFilePath]
 $myLogger.Verbose("my verbose")
 $myLogger.Error("my error")
 $myLogger.Info("my info")
.NOTES
General notes
#>
function Get-Logger{
    
        param(
            [Parameter(Mandatory=$false)][string] $namespace,
            [Parameter(Mandatory=$false)][string] $filepath = "C:\windows\Logs\Window_10_Setup\build.log",
            [Parameter(Mandatory=$false)][string]$logMutexName = "BuildLogMutex",
            [switch]$NoMutex
        )
        $LOG_FOLDER = [System.IO.Path]::GetDirectoryName($filepath)

        if(-Not (Test-Path $LOG_FOLDER)){
            New-Item $LOG_FOLDER -ItemType Directory
        }
    
        $loggerInstance = New-Module -AsCustomObject -ScriptBlock {
            
            [string]$namespace=""
            [string]$logfile=""
            [System.Threading.Mutex]$mutex=$null
            [string]$separator="|"
            [string]$dateformat="yyyy-MM-dd"
            [string]$timeformat="hh:mm:ss.ffff"
    
    
            Function Write-Msg{
                param(
                  [Parameter(Mandatory=$true,Position=0)][string] $message,
                  [Parameter(Mandatory=$false)] $bg, 
                  [Parameter(Mandatory=$false)] $fg 
                )
    
                $timestamp = Get-Date -f "$dateformat $timeformat"

                $message = "$timestamp$separator$namespace$separator$message"
               
                if($bg -and $fg){
                    Write-Host $message -BackgroundColor $bg -ForegroundColor $fg
                }elseif($bg) {
                    Write-Host $message -BackgroundColor $bg
                }elseif($fg) {
                    Write-Host $message -ForegroundColor $fg
                }else{
                    Write-Host $message
                }

                if($mutex -ne $null){
                    $mutex.WaitOne()
                }
                try{
                    $message| Add-Content $logfile
                }
                catch{
                    Write-Host "Couldn't write to $logFile, Exception Msg: $($_.Exception.Message)" -ForegroundColor "red"
                    if($ErrorActionPreference -eq "Stop"){
                        throw;
                    }
                }
                finally{
                    if($mutex -ne $null){
                        $mutex.ReleaseMutex()
                    }
                }                          
             }
    
            Function Info {
                param(
                  [Parameter(Mandatory=$true,Position=0)][string] $message
                )
                   
                [void] (Write-Msg "Info:$message" -fg "Green")
            }
    
            Function Warn {
                param(
                  [Parameter(Mandatory=$true,Position=0)][string] $message
                )   

                [void] (Write-Msg "Warn:$message" -fg "Yellow")
            }
    
            Function Error {
                param(
                  [Parameter(Mandatory=$true,Position=0)][string] $message
                )
    
                [void] (Write-Msg "Error:$message" -fg "Red")
            }
    
    
            Export-ModuleMember -Function Info
            Export-ModuleMember -Function Warn
            Export-ModuleMember -Function Error
            Export-ModuleMember -Variable *
    
        }

        $loggerInstance.namespace = $namespace;
        $loggerInstance.logfile = $filepath;
        if(-Not $NoMutex){
            $loggerInstance.mutex = New-Object System.Threading.Mutex($false, $logMutexName)
        }

        return $loggerInstance;
}

Export-ModuleMember -Function Get-Logger