



$default_server = $env:SERVER_ADDRESS;

function Patch-Panacea {

    param([string]$url ="http://$default_server/panaceabuilder/panacea.zip")
    $logger = Get-Logger "Patch Panacea"
    $destination = "P:\Panacea"
    set-ibtmode quick
    Download-Unzip $url $destination $logger
}



function Patch-Panacea-As {
    param([ValidateSet("HRH","MHRH")][string]$hospital)
    switch($hospital.ToLower()){

        "mhrh" {
            Patch-Panacea http://$default_server/PanaceaBuild/PanaceaPackages/mhrh.zip
        }
        
        "hrh" {
            Patch-Panacea http://$default_server/PanaceaBuild/PanaceaPackages/hrh.zip
        }


        default {
            Patch-Panacea
        }
    }
}



# TODO decide how to connect to server
function Patch-Modules{
    param(
        $patch_server="$default_server"
    )

    $logger = Get-Logger "PatchModule"
    $zippedFolderName="PowerShellModules"
    $zipFile="$zippedFolderName.zip"
    $url = "http://$patch_server/$zipFile"
    $_targetPath = "$Env:SystemDrive$Env:HomePath\Documents\WindowsPowerShell\_Modules"
    $targetPath = "$Env:SystemDrive$Env:HomePath\Documents\WindowsPowerShell\Modules"

    Download-Unzip $url $_targetPath $logger
    robocopy $_targetPath $targetPath /e /move /mir /r:0 /w:0
    remove-item $_targetPath -Recurse -Force -ErrorAction SilentlyContinue
    Get-Module -ListAvailable|? {$_.ModuleBase -like "$env:userprofile\Document*"} | Import-Module -DisableNameChecking -Force
}




function Patch-Tests{
    param(
        $patch_server="$default_server"
    )

    $logger = Get-Logger "PatchTest"
    $_path = "C:\_tests"
    $path = "C:\tests"
    $url = "http://$patch_server/tests.zip"
    Download-Unzip $url $_path $logger
    robocopy $_path $path /e /move /mir
    remove-item $_path -Recurse -Force -ErrorAction SilentlyContinue    
}


function Patch-Boot{
    param(
        $patch_server="$default_server"
    )

    $logger = Get-Logger "PatchBoot"
    $_path = "C:\_boot"
    $path = "C:\panacea-boot"
    $url = "http://$patch_server/boot-build.zip"
    Download-Unzip $url $_path $logger
    robocopy $_path $path /e /move /mir
    remove-item $_path -Recurse -Force -ErrorAction SilentlyContinue    
}

function Patch-Post{
    param(
        $patch_server="$default_server"
    )

    $logger = Get-Logger "PatchPost"
    $_path = "C:\_post"
    $path = "C:\post"
    $url = "http://$patch_server/post-build.zip"
    Download-Unzip $url $_path $logger
    robocopy $_path $path /e /move /mir
    remove-item $_path -Recurse -Force -ErrorAction SilentlyContinue    
}



function Update-Build {
    Wait-Network
    $logger = Get-Logger "UpdateBuild"
    invoke-webrequest "http://$default_server/enableShellLauncher.ps1" -UseBasicParsing| invoke-expression
}



Export-ModuleMember -Function Patch-Modules,Patch-Panacea,Patch-Tests,Patch-Boot,Patch-Post,Patch-Panacea-As,Update-Build