function Enable-HighPerformance {


        
            <#
            ====================================================
            This file applies the power setting
            ====================================================
            #>
        
        
            Write-Host "Started Power Settings ================================================================================================================================== $nl "
        
            # AC is wall power, DC is battery power
        
            # set high performance as active
            powercfg /s 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c
        
        
            # never turn off display
            # powercfg -change -monitor-timeout-ac 0
            # powercfg -change -monitor-timeout-dc 0
        
            # never shut down disk
            # powercfg -change -disk-timeout-ac 0
            # powercfg -change -disk-timeout-dc 0
        
            # never turn on standby
            powercfg -change -standby-timeout-ac 0
            powercfg -change -standby-timeout-dc 0
        
        
            # never hibernate
            powercfg -change -hibernate-timeout-ac 0
            powercfg -change -hibernate-timeout-dc 0
        
        
        
            # set high performance power settings to do nothing on close
            # GUID 1: High Performance Power Settings | GUID 2: Power buttons and lid settings | GUID 3: Lid close action
            powercfg -setacvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 5ca83367-6e45-459f-a27b-476b1d01c936 0
            powercfg -setdcvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 5ca83367-6e45-459f-a27b-476b1d01c936 0
        
        
            # set high performance power settings to do nothing on power button
            # GUID 1: High Performance Power Settings | GUID 2: Power buttons and lid settings | GUID 3: Power button action
            powercfg -setacvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 7648efa3-dd9c-4e3e-b566-50f929386280 0
            powercfg -setdcvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 7648efa3-dd9c-4e3e-b566-50f929386280 0
        
        
            # set high performance power settings to do nothing on sleep button
            # GUID 1: High Performance Power Settings | GUID 2: Power buttons and lid settings | GUID 3: Sleep button action
            powercfg -setacvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 96996bc0-ad50-47ec-923b-6f41874dd9eb 0
            powercfg -setdcvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 96996bc0-ad50-47ec-923b-6f41874dd9eb 0
        
        
            # Do not require password when computer wakes up
            # GUID 1: High Performance Power Settings | GUID 2: No sub group | GUID 3: Console lock
            powercfg -setacvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c fea3413e-7e05-4911-9a71-700331f1c294 0e796bdb-100d-47d6-a2d5-f7d2daa51f51 0
            powercfg -setdcvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c fea3413e-7e05-4911-9a71-700331f1c294 0e796bdb-100d-47d6-a2d5-f7d2daa51f51 0
        
        
            # Never turn off disk
            # GUID 1: High Performance Power Settings | GUID 2: Hard Disk | GUID 3: Turn off hard disk
            powercfg -setacvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 0012ee47-9041-4b5d-9b77-535fba8b1442 6738e2c4-e8a5-4a42-b16a-e040e769756e 0
            powercfg -setdcvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 0012ee47-9041-4b5d-9b77-535fba8b1442 6738e2c4-e8a5-4a42-b16a-e040e769756e 0
        
        
            # Never turn off display
            # GUID 1: High Performance Power Settings | GUID 2: Display | GUID 3: Turn off display after
            powercfg -setacvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 7516b95f-f776-4464-8c53-06167f40cc99 3c0bc021-c8a8-4e07-a973-6b14cbcb2b7e 0
            powercfg -setdcvalueindex 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 7516b95f-f776-4464-8c53-06167f40cc99 3c0bc021-c8a8-4e07-a973-6b14cbcb2b7e 0
}


Export-ModuleMember -Function Enable-HighPerformance