function Run-Tests {
    param(
        [Parameter(Mandatory = $false)][string] $testFolderPath = "C:\Tests",
        [Parameter(Mandatory = $false)] $subtest = "Default"
    )

    if (-Not $testFolderPath) {
        $testFolderPath = "C:\Tests"
    }

    if ($subtest) {
        $testFolderPath = "$testFolderPath\$subtest"
    }


    
    if (Test-Path $testFolderPath) {

        Push-Location $testFolderPath
        Import-Module Pester
        Invoke-Pester -OutputFile "$env:SystemRoot\Logs\Window_10_Setup\Report.xml" -OutputFormat NUnitXml
        Pop-Location
    }
    else {
        if ($subtest) {
            throw [System.IO.FileNotFoundException] "$subtest is not a valid test"
        }
        else {
            throw [System.IO.FileNotFoundException] "TestCase Files not found. Incorrect installation of Test. Please Notify System Admin"
        }
    }
}


function Import-Test {
    param(
        [Parameter(Mandatory = $true, Position = 0)] $Test, 
        [Parameter(Mandatory = $false)] $testFolderPath = "C:\Tests"
    )

    $test = "$testFolderPath\$Test"

    if (-Not $test) {
        throw [System.IO.FileNotFoundException] "Imported Test $Test does not exist"
    }
    else {
        $loaded_test = Get-ChildItem $test
        $loaded_test | ForEach-Object { . $_.FullName }
    }

}


Export-ModuleMember -Function Import-Test
Export-ModuleMember -Function Run-Tests