$defaultStore = "$env:userprofile\store.json"


#region to be exported


function Set-Discard{
    param($file )
    Add-Discard $file $defaultStore
}


function Clear-Discard{
    $container = Load-Discard $defaultStore
    $container| remove-item -Recurse -Force
    Save-Discard @()
}

#endregion 

function Add-Discard{
    param($file,$store)
    [Object[]] $container = Load-Discard $store

    write-host $container.GetType()

    $container += $file
    Save-Discard $container
}


function Load-Discard{
    param($store)
    
    if(Test-Path $store){
        $files = Get-Content $store | ConvertFrom-Json
    }else{
        $files = @()
    }
    return $files
}

function Save-Discard{
    param($container)
    $container|ConvertTo-Json | Out-file -FilePath $defaultStore
}

Export-ModuleMember -Function Set-Discard
Export-ModuleMember -Function Clear-Discard
