function CatchError {
    param(
        [Parameter(Position=0)][ScriptBlock] $scriptblock,
        [Parameter(Position=1, Mandatory=$true)]$onErrorMsg,
        [Parameter(Position=2, Mandatory=$false)]$logger
    )
    write-host $ErrorActionPreference
    try {
        & $scriptblock
    }
    catch {
        $message = $onErrorMsg + ": $($_.Exception.Message)"

        if ($logger) {
            $logger.Warn($message)
        }

        if ($ErrorActionPreference -eq "Stop") {
            throw
        }
    }
}



function Run-Once{
    param(
        $name, $command,$logger = (Get-logger "RunOnce")
    )

    $path="HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce"

    $logger.info("adding $name $command")
    if(-Not (Test-Path $path)){
        New-Item $path
    }

    New-ItemProperty -path $path  -name $name -value $command -Force
}


function Run-Always{
    param(
        $name, $command,$logger = (Get-logger "RunAlways")
    )

    $path="HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
    
    $logger.info("adding $name $command")
    if(-Not (Test-Path $path)){
        New-Item $path
    }
    
    New-ItemProperty -path $path  -name $name -value $command -Force
}


function Remove-Always{
    param($name, $logger = (Get-Logger "Remove-Always"))
    $path="HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
    if((Test-Path $path)){
        Remove-ItemProperty -path $path -name $name -Force
    }
}


function Apply-Post{

    [string] $downloadPath="C:\post"
    $registry_run_path = "HKLM:\Software\Microsoft\Windows\CurrentVersion\RunOnce"
    $logger = (Get-Logger "ApplyPost")
    
    function Set-RunCommand {
        param(
            $name,
            $value
        )
        $m = $MyInvocation.MyCommand
        $logger.Info("In $m, before adding $registry_run_path, command $value")
        Set-ItemProperty -Path $registry_run_path -Name $name -Value $value -Force
        $logger.Info("In $m, after adding $registry_run_path, command $value")
    }


    $children = Get-ChildItem $downloadPath
    
    $children | % {
        $current = $_
        Set-RunCommand $current.BaseName "powershell -windowstyle hidden -f `"$($current.FullName)`""
    }
}


function Apply-Boot{

    [string] $downloadPath="C:\panacea-boot"
    $registry_run_path = "HKCU:\Software\Microsoft\Windows\CurrentVersion\Run"
    $logger = (Get-Logger "ApplyBoot")
    
    function Set-RunCommand {
        param(
            $name,
            $value
        )
        $m = $MyInvocation.MyCommand
        $logger.Info("In $m, before adding $registry_run_path, command $value")
        Set-ItemProperty -Path $registry_run_path -Name $name -Value $value -Force
        $logger.Info("In $m, after adding $registry_run_path, command $value")
    }


    $children = Get-ChildItem $downloadPath
    
    $children | % {
        $current = $_
        Set-RunCommand $current.BaseName "powershell -windowstyle hidden -f `"$($current.FullName)`""
    }
}



Export-ModuleMember -Function *