$mms_cfg_location_x86 = "C:\Windows\System32\Macromed\Flash\"

$mms_cfg_location_x64 = "C:\Windows\SysWOW64\Macromed\Flash\"

$mms_cfg_file = "mms.cfg"

$mms_cfg_autoupdate = "AutoUpdateDisable=1"

$mms_cfg_slientupdate = "SilentAutoUpdateEnable=1"

$mms_cfg_newline = "`r`n"


if ($ENV:ARCHITECTURE -eq "64-bit"){
  write-mms_cfg($mms_cfg_location_x86)
  write-mms_cfg($mms_cfg_location_x64)
}else{
  write-mms_cfg($mms_cfg_location_x86)
}

function write-mms_cfg ($path) {
  if (!(Test-Path $path$mms_cfg_file))
  {
    New-Item -path $path -name $mms_cfg_file -type "file" -value "$mms_cfg_autoupdate$mms_cfg_newline$mms_cfg_slientupdate"
    Write-Host "Created new mms.cfg file in $mms_cfg_location_x64"
  }else{
    (Get-Content $path$mms_cfg_file).replace('AutoUpdateDisable=0', $mms_cfg_autoupdate) | Set-Content $path$mms_cfg_file
    (Get-Content $path$mms_cfg_file).replace('SilentAutoUpdateEnable=0', $mms_cfg_slientupdate) | Set-Content $path$mms_cfg_file
  }
}
