<#
	Runs key filtering script from server
#>


<#
powershell.exe -nop -c "iex(New-Object Net.WebClient).DownloadString('http://$ENV:SERVER_ADDRESS/$ENV:PANACEA_BUILDER/EnableKeyboardFilter.ps1')" >> c:\keyboardfilter.log
#>

Write-Host "Started keyfilter ================================================================================================================================== $nl "

$CommonParams = @{"namespace"="root\standardcimv2\embedded";"computername"="$env:computername"}
$Id = ""


function Enable-Predefined-Key($Id) {
    $predefined = Get-WMIObject -class WEKF_PredefinedKey @CommonParams |
        where {
            $_.Id -eq "$Id"
        };

    if ($predefined) {
        $predefined.Enabled = 1;
        $predefined.Put() | Out-Null;
        Write-Host "Enabled $Id $nl"
    } else {
        Write-Error "$Id is not a valid predefined key $nl"
    }
}

function Disable-Predefined-Key($Id) {
    $predefined = Get-WMIObject -class WEKF_PredefinedKey @CommonParams |
        where {
            $_.Id -eq "$Id"
        };

    if ($predefined) {
        $predefined.Enabled = 0;
        $predefined.Put() | Out-Null;
        Write-Host "Disabled Predefined-Key $Id. $nl"
    } else {
        Write-Error "$Id is not a valid predefined key $nl"
    }
}

function Enable-Custom-Key($Id) {
    $custom = Get-WMIObject -class WEKF_CustomKey @CommonParams |
        where {
            $_.Id -eq "$Id"
        };

    if ($custom) {
# Rule exists.  Just enable it.
        $custom.Enabled = 1;
        $custom.Put() | Out-Null;
        Write-Host "Enabled Custom-key $Id. $nl"

    } else {
        Set-WMIInstance `
            -class WEKF_CustomKey `
            -argument @{Id="$Id"} `
            @CommonParams | Out-Null

        Write-Host "Added Custom Filter $Id. $nl"
    }
}
function Disable-Custom-Key($Id) {
    $custom = Get-WMIObject -class WEKF_CustomKey @CommonParams |
        where {
            $_.Id -eq "$Id"
        };

    if ($custom) {
# Rule exists.  Just disable it.
        $custom.Enabled = 0;
        $custom.Put() | Out-Null;
        Write-Host "Disabled Custom Filter $Id. $nl"
    } else {
        Set-WMIInstance `
            -class WEKF_CustomKey `
            -argument @{Id="$Id"} `
            @CommonParams | Out-Null

        Write-Host "Added Custom Filter $Id. $nl"
    }
}

function Enable-Scancode($Modifiers, [int]$Code) {
    $scancode =
        Get-WMIObject -class ac @CommonParams |
            where {
                ($_.Modifiers -eq $Modifiers) -and ($_.Scancode -eq $Code)
            }

    if($scancode) {
        $scancode.Enabled = 1
        $scancode.Put() | Out-Null
        write-host "$nl Enabled Custom Scancode {0}+{1:X4}" -f $Modifiers, $Code
    } else {
        Set-WMIInstance `
            -class WEKF_Scancode `
            -argument @{Modifiers="$Modifiers"; Scancode=$Code} `
            @CommonParams | Out-Null

        write-host " $nl Added Custom Scancode {0}+{1:X4}" -f $Modifiers, $Code
    }
}

function Get-Setting([String] $Name) {
    $Entry = Get-WMIObject -class WEKF_Settings @CommonParams |
        where {
            $_.Name -eq $Name
        }
    return $Entry
}

function Set-DisableKeyboardFilterForAdministrators([Bool] $Value) {
    $Setting = Get-Setting("DisableKeyboardFilterForAdministrators")
    if ($Setting) {
        if ($Value) {
            $Setting.Value = "true" 
        } else {
            $Setting.Value = "false"
        }
        $Setting.Put() | Out-Null;
    } else {
        Write-Error "Unable to find DisableKeyboardFilterForAdministrators setting";
    }
}

function Set-ForceOffAccessibility([Bool] $Value) {
    $Setting = Get-Setting("ForceOffAccessibility")
    if ($Setting) {
        if ($Value) {
            $Setting.Value = "true" 
        } else {
            $Setting.Value = "false"
        }
        $Setting.Put() | Out-Null;
    } else {
        Write-Error "Unable to find ForceOffAccessibility setting";
    }
}

function Get-Setting([String] $Name) {
    $Entry = Get-WMIObject -class WEKF_Settings @CommonParams |
        where {
            $_.Name -eq $Name
        }
    return $Entry
}
#Disable all keys
write-host "Things start here =================================================================================="
Write-Host "Forloop for disabling all predefined keys $nl"
Get-WMIObject -class WEKF_PredefinedKey @CommonParams |
    foreach {
		write-host $_.id " is " $_.Enabled
        if (-Not $_.Enabled) {
            $_.Enabled = 1;
            $_.Put() | Out-Null;
            Write-Host "Enabled Predefined-Key " $_.Id " $nl"
        }
    }

Write-Host "Forloop for disabling all custom keys $nl"
Get-WMIObject -class WEKF_CustomKey @CommonParams |
    foreach {
		write-host $_.id " is " $_.Enabled
        if (-Not $_.Enabled) {
            $_.Enabled = 1;
            $_.Put() | Out-Null;
            Write-Host "Enabled Custom key " $_.Id "$nl"
        }
    }
	
Write-Host "Forloop for disabling all custom scancodes $nl"
Get-WMIObject -class WEKF_Scancode @CommonParams |
    foreach {
		write-host $_.id " is " $_.Enabled
        if (-Not $_.Enabled) {
            $_.Enabled = 1;
            $_.Put() | Out-Null;
            Write-Host "$nl Enabled {0}+{1:X4}" -f $_.Modifiers,$_.Scancode
        }
    }
write-host "Disable Preset Keys =================================================================================="
# Some example uses of the functions defined above.
Disable-Predefined-Key "Ctrl"
Disable-Predefined-Key "Shift"
Disable-Predefined-Key "Alt"
Disable-Predefined-Key "Escape"
Disable-Predefined-Key "Shift+Ctrl+Esc"
Disable-Custom-Key "Oemcomma"

write-host "Disable custom Keys =================================================================================="

write-host "Disable Admin / Accessibility========================================================================="
#Set for admins
Set-DisableKeyboardFilterForAdministrators $false
#Turn off Assessibility bypass
Set-ForceOffAccessibility $true
##