
$ignore=@("Windows","Panacea")

if (Get-Command "Get-Volume" -errorAction SilentlyContinue)
{
    $best_option = Get-Volume| ?{ -Not ($ignore -contains $_.FileSystemLabel) } | ? { $_.DriveType -eq "Fixed"} | Sort-Object -Property SizeRemaining -Descending| ? {$_.DriveLetter} | Select -First 1
    $win7=$false
}else{
    $best_option = Get-WmiObject Win32_LogicalDisk | ?{ -Not ($ignore -contains $_.VolumeName) } | ? { $_.DriveType -eq 3} | Sort-Object -Property FreeSpace -Descending|select -first 1
    $win7=$true
}

if($best_option){
    $best_option
    if($win7){
        $path =  "$($best_option.Name)\Log\Application.evtx"
    }else{
        $path = "$($best_option.DriveLetter):\Log\Application.evtx"
    }

    New-Item -ItemType Directory "$($best_option.DriveLetter):\Log"
    
    Set-ItemProperty "HKLM:\SYSTEM\CurrentControlSet\Services\Eventlog" -Name "File" -Value $path
}