
$ignore=@("Windows","Panacea")

if (Get-Command "Get-Volume" -errorAction SilentlyContinue)
{
    $best_option = Get-Volume| ?{ -Not ($ignore -contains $_.FileSystemLabel) } | ? { $_.DriveType -eq "Fixed"} | Sort-Object -Property SizeRemaining -Descending| ? {$_.DriveLetter} | Select -First 1
    $win7=$false
}else{
    $best_option = Get-WmiObject Win32_LogicalDisk | ?{ -Not ($ignore -contains $_.VolumeName) } | ? { $_.DriveType -eq 3} | Sort-Object -Property FreeSpace -Descending|select -first 1
    $win7=$true
}


$computer = Get-WmiObject Win32_computersystem -EnableAllPrivileges
$computer.AutomaticManagedPagefile = $false
$computer.Put()


$CurrentPageFile = Get-WmiObject -Query "select * from Win32_PageFileSetting where name='c:\\pagefile.sys'"
$CurrentPageFile

if($CurrentPageFile){
    $CurrentPageFile.delete()
}

if($best_option){
    $best_option
    if($win7){
        $args =  @{name="$($best_option.Name)\\pagefile.sys";InitialSize = 0; MaximumSize = 0}
    }else{
        $args =  @{name="$($best_option.DriveLetter):\\pagefile.sys";InitialSize = 0; MaximumSize = 0}
    }
    $args
    Set-WMIInstance -Class Win32_PageFileSetting -Arguments $args
}
