<#
============================================================

    Switched to Exe to apply the write filter

============================================================
#>


#TODO this needs to be placed in an array


    $logger = Get-Logger "t_writeFilters"

    $logger.Info("Configuring write filter");
    
    $script_directory = "$env:HOMEPATH\Powershell"

    New-Item -ItemType Directory -Path $script_directory

    $GB_SIZE=1024;
    $overlay_type = "DISK";

    $overlay_size = [math]::Round(2 * $GB_SIZE);
    
    $warningSize = [math]::Round(1.5 * $GB_SIZE);
    
    $criticalSize = [math]::Round(1.7 * $GB_SIZE);


    $x = "uwfmgr.exe";



    # =====================================================================
    #   Set the uwfmgr to bind by drive letter rather than volume
    #======================================================================

    $COMPUTER = "localhost"
    $NAMESPACE = "root\standardcimv2\embedded"
    $CommonParams = @{"namespace"=$NAMESPACE; "computer"=$COMPUTER}
    $driveLetter = "C:"

    $nextConfig = Get-WMIObject -class UWF_Volume @CommonParams |
    where {
        $_.DriveLetter -eq "$driveLetter" -and $_.CurrentSession -eq $false
    };
      
    $logger.Info("Enabling filter");
    & $x filter enable;
    
    $logger.Info("Setting overlay size to $overlay_size");
    & $x overlay set-size $overlay_size
    
    $logger.Info("Setting overlay type to DISK");
    & $x overlay set-type $overlay_type
    
    $logger.Info("Setting critical size to $criticalSize");
    & $x overlay Set-CriticalThreshold $criticalSize
    
    $logger.Info("Setting warning size to $warningSize");
    & $x overlay Set-WarningThreshold $warningSize

    $logger.Info("Protecting volume C");
    & $x Volume Protect C:

    $logger.Info("Setting an exclusion for C:\init directory");
    & $x File Add-Exclusion "C:\init";

    $logger.Info("Setting an exclusion for C:\scripts directory");
    & $x File Add-Exclusion "C:\scripts";
    
    $logger.Info("Setting an exclusion for $script_directory directory");
    & $x File Add-Exclusion "$script_directory";

    $logger.Info("Setting an exclusion for the Winlogon registry key");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows NT\CurrentVersion\WinLogon"


    <# 
    =====================================================================================
                New Settings 
                This is for Windows Defender. These are all of the paths and 
                files that needs to be excluded.
    =====================================================================================
    #>



    #Folders
    $logger.Info("Add exclusion for C:\Program Files\Windows Defender");
    & $x File Add-Exclusion "C:\Program Files\Windows Defender"

    $logger.Info("Add exclusion for C:\ProgramData\Microsoft\Windows Defender");    
    & $x File Add-Exclusion "C:\ProgramData\Microsoft\Windows Defender"

    $logger.Info("Add exclusion for C:\Program Files\Microsoft Security Client");
    & $x File Add-Exclusion "C:\Program Files\Microsoft Security Client"
    
    $logger.Info("Add exclusion for C:\ProgramData\Microsoft\Microsoft Antimalware");
    & $x File Add-Exclusion "C:\ProgramData\Microsoft\Microsoft Antimalware"

    # Files
    if(-Not (Test-Path "C:\Windows\debug")){
        $logger.Info("Making C:\Windows\debug directory");
        mkdir C:\Windows\Debug
    }

    

    $windows_debug = "C:\Windows\debug"
    $logger.Info("Add exclusion for $windows_debug");
    & $x File Add-Exclusion "$windows_debug"
    
    $windows_update_log = "C:\Windows\WindowsUpdate.log"
    $logger.Info("Add exclusion for $windows_update_log");
    & $x File Add-Exclusion "$windows_update_log"
    
    $windows_defend_run_log = "C:\Windows\Temp\MpCmdRun.log"
    $logger.Info("Add exclusion for $windows_defend_run_log");
    & $x File Add-Exclusion "$windows_defend_run_log"
    

    $windows_update = "C:\Windows\Windowsupdate.log"
    $logger.Info("Add exclusion for $windows_update");
    & $x File Add-Exclusion "$windows_update"


    #Registry
    $windows_defender_registry = "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows Defender"
    $logger.Info("Add exclusion for $windows_defender_registry");
    & $x Registry Add-Exclusion "$windows_defender_registry";
    


    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft Antimalware");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft Antimalware";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon";



    #New To be Tested


    # File
    
    $logger.Info("Add exclusion for C:\Windows\wlansvc\Policies");
    & $x File Add-Exclusion "C:\Windows\wlansvc\Policies";
    
    $logger.Info("Add exclusion for C:\Windows\dot2svc\Policies");
    & $x File Add-Exclusion "C:\Windows\dot2svc\Policies";
    
    $logger.Info("Add exclusion for $env:ALLUSERSPROFILE\Microsoft\Network\Downloader");
    & $x File Add-Exclusion "$env:ALLUSERSPROFILE\Microsoft\Network\Downloader";
    
    $logger.Info("Add exclusion for C:\ProgramData\Microsoft\wlansvc\Profiles\Interfaces");
    & $x File Add-Exclusion "C:\ProgramData\Microsoft\wlansvc\Profiles\Interfaces";
    
    $logger.Info("Add exclusion for C:\ProgramData\Microsoft\dot3svc\Profiles\Interfaces");
    & $x File Add-Exclusion "C:\ProgramData\Microsoft\dot3svc\Profiles\Interfaces";



    # Meditech
    $logger.Info("Add exclusion for C:\ProgramData\MEDITECH");
    & $x File Add-Exclusion "C:\ProgramData\MEDITECH";

    $logger.Info("Add exclusion for C:\Program Files (x86)\MEDITECH");
    & $x File Add-Exclusion "C:\Program Files (x86)\MEDITECH";

    $logger.Info("Add exclusion for C:\Program Files\MEDITECH");
    & $x File Add-Exclusion "C:\Program Files\MEDITECH";

    # Registry
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\Wlansvc");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\Wlansvc";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\WwanSvc");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\WwanSvc";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\dot3svc");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\dot3svc";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time Zones";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\TimeZoneInformation");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Control\TimeZoneInformation"
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\Software\Policies\Microsoft\SQMClient\Windows\CEIPEnable");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\Software\Policies\Microsoft\SQMClient\Windows\CEIPEnable";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\Software\Microsoft\SQMClient\Windows\CEIPEnable");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\Software\Microsoft\SQMClient\Windows\CEIPEnable";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\Software\Microsoft\SQMClient\UploadDisableFlag");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\Software\Microsoft\SQMClient\UploadDisableFlag";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\BITS\StateIndex");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\BITS\StateIndex";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\Wireless\GPTWirelessPolicy");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\Wireless\GPTWirelessPolicy";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\WiredL2\GP_Policy");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Policies\Microsoft\Windows\WiredL2\GP_Policy";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\wlansvc");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\wlansvc";
    
    $logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\dot3svc");
    & $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\dot3svc";
    
    & $x filter disable;

    $registry_key = "HKLM:\SYSTEM\CurrentControlSet\Control\Session Manager"
    $boot_settings = "autocheck autochk /K:C *"
    New-ItemProperty -Path $registry_key -Name "BootExecute" -PropertyType String -Value $boot_settings  -Force



    $registry_key = "HKLM:\SYSTEM\CurrentControlSet\Services\FsDepends"
    $boot_type = 0
    New-ItemProperty -Path $registry_key -Name "Start" -PropertyType DWord -Value $boot_type  -Force





<#
================================================================================================================================


                                                    Symantec New Settings


================================================================================================================================
#>



#Files
$logger.Info("Add exclusion for C:\Program Files (x86)\Symantec\Symantec Endpoint Protection\14.2.770.0000.105\Bin\CmnClnt");
& $x File Add-Exclusion "C:\Program Files (x86)\Symantec\Symantec Endpoint Protection\14.2.770.0000.105\Bin\CmnClnt";


$logger.Info("Add exclusion for C:\ProgramData\Symantec\Symantec Endpoint Protection\14.2.770.0000.105");
& $x File Add-Exclusion "C:\ProgramData\Symantec\Symantec Endpoint Protection\14.2.770.0000.105";


$logger.Info("Add exclusion for C:\WINDOWS\system32\Drivers\SEP\0E020302\0000.105");
& $x File Add-Exclusion "C:\WINDOWS\system32\Drivers\SEP\0E020302\0000.105";


$logger.Info("Add exclusion for C:\WINDOWS\ElamBkup\SEP\0E020302\0000.105");
& $x File Add-Exclusion "C:\WINDOWS\ElamBkup\SEP\0E020302\0000.105";


$logger.Info("Add exclusion for C:\ProgramData\Symantec\Symantec Endpoint Protection\PersistedData");
& $x File Add-Exclusion "C:\ProgramData\Symantec\Symantec Endpoint Protection\PersistedData";


$logger.Info("Add exclusion for C:\Program Files (x86)\Common Files\Symantec Shared");
& $x File Add-Exclusion "C:\Program Files (x86)\Common Files\Symantec Shared";


$logger.Info("Add exclusion for C:\ProgramData\SymEFASI");
& $x File Add-Exclusion "C:\ProgramData\SymEFASI";


$logger.Info("Add exclusion for C:\WINDOWS\system32\Drivers\SymEFASI");
& $x File Add-Exclusion "C:\WINDOWS\system32\Drivers\SymEFASI";


#Registry

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymEFASI");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymEFASI";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SepMasterServiceMig");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SepMasterServiceMig";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SepMasterService");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\SepMasterService";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\[SILO_REGHIVE]\{49637904-45A4-4055-89A1-2511D4C15A1D}\Common Client\PathExpansionMap");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\[SILO_REGHIVE]\{49637904-45A4-4055-89A1-2511D4C15A1D}\Common Client\PathExpansionMap";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Symantec\SharedDefs");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Symantec\SharedDefs";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\Teefer2");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\Teefer2";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Symantec\Symantec AntiVirus");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Symantec\Symantec AntiVirus";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SYMTDI");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SYMTDI";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymIRON");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymIRON";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\ccSettings_{49637904-45A4-4055-89A1-2511D4C15A1D}");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\ccSettings_{49637904-45A4-4055-89A1-2511D4C15A1D}";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SRTSPX");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SRTSPX";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymELAM");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymELAM";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SepLpsService");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SepLpsService";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\heCAF");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\heCAF";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSUtil");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSUtil";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSService");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSService";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIDSService");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIDSService";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIDSRegDrv");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIDSRegDrv";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSDeviceFilter");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSDeviceFilter";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSDriver");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSDriver";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSFileFilter");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSFileFilter";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSNetFilter");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SISIPSNetFilter";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SysPlant");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SysPlant";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SyDvCtrl");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SyDvCtrl";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SNAC");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SNAC";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SYMTDIV");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SYMTDIV";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SYMNETS");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SYMNETS";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\BHDrvx64");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\BHDrvx64";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SRTSP");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SRTSP";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\IDSxpa64");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\IDSxpa64";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\IDSVia64");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\IDSVia64";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymEvent");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\services\SymEvent";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\HKLM\SOFTWARE\Wow6432Node\Symantec\Symantec Endpoint Protection\SMC");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\HKLM\SOFTWARE\Wow6432Node\Symantec\Symantec Endpoint Protection\SMC";

$logger.Info("Add exclusion for HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Symantec\Symantec Endpoint Protection\{49637904-45A4-4055-89A1-2511D4C15A1D}");
& $x Registry Add-Exclusion "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Symantec\Symantec Endpoint Protection\{49637904-45A4-4055-89A1-2511D4C15A1D}";




<#
    This is needed to remove the need to run set-ibt mode twice
    HKCU:\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer
#>


$logger.Info("Add exclusion for HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer");
& $x Registry Add-Exclusion "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer";