
<#
.SYNOPSIS
returns an ArrayList of all applicastions installed in a way that Control Panel->Projgrams and Features

.DESCRIPTION
Known exception: K-lite is visible in Programs and Features, but is not returned by this function.

.EXAMPLE
An example

.NOTES
General notes
#>
function Get-Applications {
    return Get-WmiObject win32_product
}

function Test-AppInstalledIfNotProperWindowsInstall ($app) {
    It "Should have $app installed" {
        $installedApp = Get-Command $app
        $installedApp.Name | Should Be "$app"
    }
}

function Test-AppInstalled($applications, $app) {
    It "should have $app" {
        $applications | where-object Name -Match $app | Should Not BeNullOrEmpty
    }
}

Describe "Application Installed Tests" {
    
    $applications = Get-Applications

    It "should have K-Lite" {
        $klite = "K-Lite Codec Pack"
        $result = if ((Test-Path "C:\Program Files\$klite") -or (Test-Path "C:\Program Files (x86)\$klite")) {$true} else {$false}
        $result | Should be $true
    }

    # Test-AppInstalled $applications "Skype"
    
    Test-AppInstalled $applications "Adobe Acrobat Reader"

    It "should have Adobe Flash" {
        $flash = get-item C:\Windows\System32\Macromed\Flash\Flash.ocx
        $flash = $flash.VersionInfo.FileVersion
        $flash | Should Not BeNullOrEmpty
    }

    Test-AppInstalled $applications "Java"

    <#
        https://www.microsoft.com/getsilverlight/resources/documentation/grouppolicysettings#AutoUpdateNote

        Important Silverlight's Automatic Update registry setting can be implemented per-user and per-machine. 
        Even though entries get automatically written to the user key (HKCU) upon install, the ADMX templates 
        only support writing to the machine key (HKLM) because these settings cannot be overridden by using 
        the Silverlight user interface or by modifying the per-user update mode registry key
    #>
    $ApplicationName = "Silverlight"
    Context $ApplicationName {


        BeforeAll {

            <#
                The space on both sides are critical without it the 
                syntax would fail and produce an error.
            #>
            Enum SilverlightUpdateMode {
                Auto = 0
                Prompt = 1
                Disabled = 2
            }
        }

        It "$ApplicationName should not be installed" {
            $applications | where-object Name -Match $ApplicationName | Should BeNullOrEmpty
        }
        # It "$ApplicationName Update should be set to disabled for HKCU" {
        #     Get-ItemPropertyValue -Path "HKCU:\Software\Microsoft\Silverlight" -name "UpdateMode" | Should Be ([Int][SilverlightUpdateMode]::Disabled)
        # }

        # It "$ApplicationName Update should be set to disabled for HKLM" {
        #     Get-ItemPropertyValue -Path "HKLM:\Software\Microsoft\Silverlight" -name "UpdateMode" | Should Be ([Int][SilverlightUpdateMode]::Disabled)
        # }
    }

    Test-AppInstalledIfNotProperWindowsInstall "choco.exe"

    Test-AppInstalledIfNotProperWindowsInstall "curl.exe"

    if($env:HorizonVMware){
        Test-AppInstalled $applications "Vmware Horizon Client"
    }

    if($env:PANACEA_HOSPITAL_NAME -eq "HRH"){
        Test-AppInstalled $applications "Metasys"
    }
}

