function Get-ComputerModel {

    return Get-WmiObject -class Win32_Computersystem | Select-Object manufacturer, model;

}

$computer = Get-ComputerModel;

Describe "Defaults" {


    if ($env:PANACEA_DEVICE -ne "DevMachine") {

    
    
        if ($computer.model -eq "Medi-Link 18.5 (REM-ML-EKAB-001)") {
            It "should have PANACEA_DEVICE set to Remedi v1" {
                $ENV:PANACEA_DEVICE | Should Be "Remedi v1";
            }
        }

        if ($computer.model -eq "JAO18") {
            It "should have PANACEA_DEVICE set to JAO18" {
                $ENV:PANACEA_DEVICE | Should Be "JAO18";
            }
        }

        if ($computer.model -eq "JAO-CORE-S-C423-945GME-00-02") {
            It "should have PANACEA_DEVICE set to ARIE1" {
                $ENV:PANACEA_DEVICE | Should Be "ARIE1";
            }
        }

        if ($computer.model -eq "ST-185C") {
            It "should have PANACEA_DEVICE set to ARIE2" {
                $ENV:PANACEA_DEVICE | Should Be "ARIE2";
            }
        }

        if ($computer.model -eq "Surface Pro 3") {
            It "should have PANACEA_DEVICE set to Surface Pro 3" {
                $ENV:PANACEA_DEVICE | Should Be "Surface Pro 3";
            }
        }
    }
}