function Test-AppInstalled ($app){
    It "Should have $app installed" {
        $installedApp = Get-Command $app
        $installedApp.Name | Should Be "$app"
    }       
}

Describe "Default Windows Applications Installed Tests" {

    # Test-AppInstalled "uwfmgr.exe"
    Test-AppInstalled "tzutil.exe"
    Test-AppInstalled "hostname.exe"
    Test-AppInstalled "cleanmgr.exe"


    It "should have w32time Running" {
        $services = Get-Service | Where-Object {$_.Name -match "w32time" -or $_.DisplayName -match "w32time"}
        $services.StartType | Should Be "Automatic"
    }
}

