function Get-MachineENV{
    param(
        [Parameter(Mandatory=$true)][string]$env_name
    )

    return [System.Environment]::GetEnvironmentVariable($env_name,[System.EnvironmentVariableTarget]::Machine)
}

Describe "Environmental Variables" {
    It "should not have USERPASSWORD env var set once script complete" {
        Get-MachineENV "USERPASSWORD" | Should BeNullOrEmpty
    }
    
    It "should not have PANACEA_SUPPORT_PASSWORD env var set once script complete" {
        Get-MachineENV "PANACEA_SUPPORT_PASSWORD" | Should BeNullOrEmpty
    }
    
    # It "should not have SERVER_ADDRESS env var set once script complete" {
    #     Get-MachineENV "SERVER_ADDRESS" | Should BeNullOrEmpty
    # }
    
    It "should not have PANACEA_BUILDER env var set once script complete" {
        Get-MachineENV "PANACEA_BUILDER" | Should BeNullOrEmpty
    }   
}
