Describe "Firewall" {

    It "Should allow all traffic to panacea.exe" {
        $firewall = get-NetFirewallRule -DisplayName 'Allow Panacea.exe'
        $firewall.action | Should Be "allow";
    }

    It "Should allow all traffic to ibt.updater.exe" {
        $firewall = get-NetFirewallRule -DisplayName 'Allow IBT.Updater.exe'
        $firewall.action | Should Be "allow";
    }

    It "Should allow all traffic to PanaceaLauncher.exe" {
        $firewall = get-NetFirewallRule -DisplayName 'Allow PanaceaLauncher.exe'
        $firewall.action | Should Be "allow";
    }

    It "Should allow PSExec" {
        $firewall = get-NetFirewallRule -DisplayName 'Allow PSexec'
        $firewall.action | Should Be "allow";
    }

    It "Should allow Ping" {
        $firewall = get-NetFirewallRule -DisplayName 'Allow Ping'
        $firewall.action | Should Be "allow";
    }

    It "Should set all LocalSubnet* rules to allow any remote address" {
        Get-NetFirewallRule -All | Get-NetFirewallAddressFilter | Where-Object -Property { $_.RemoteAddress -Eq "LocalSubnet*" } | Get-NetFirewallRule | foreach-object {
            it "$_.RemoteAddress should be set to any" {
                $_.RemoteAddress | Should Be "any";
            }
        }
    }

}