Describe "Microsoft Monitoring" {

    It "should not have Microsoft Compatibility Appraiser tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "Microsoft Compatibility Appraiser"

        if($schTask) {
            $schTask.State | Should Be "disabled"
        }
    }


    It "should have no ProgramDataUpdater tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "ProgramDataUpdater"

        if($schTask) {
            $schTask.State | Should Be "Disabled"
        }
    }


    It "should have no StartupAppTask tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "StartupAppTask"

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }


    It "should have no Consolidator tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "Consolidator"

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }


    It "should have no KernelCeipTask tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "KernelCeipTask"

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }


    It "should have no UsbCeip tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "UsbCeip"

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }


    It "should have no Proxy tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "Proxy"

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }


    It "should have no Automatic App Update tasks scheduled" {
        $schTask = Get-ScheduledTask | where-object Taskname -match "Automatic App Update"

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }
}