Describe "Registry Key/Values" {

    #autologin
    It "should not have an AutoLogonCount" {
        $reg = {(Get-ItemPropertyValue  "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\WinLogon" -name AutoLogonCount)}
        $reg | Should Throw
    }

    It "should have AutoAdminLogon set to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\WinLogon" -name AutoAdminLogon)
        $reg | Should Be "1"
    }

    It "should have DefaultDomainName set to ." {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\WinLogon" -name DefaultDomainName)
        $reg | Should Be "."
    }

    It "should have DefaultUserName set to panuser" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\WinLogon" -name DefaultUserName)
        $reg | Should Be "panuser"
    }

    It "should have DefaultPassword set" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\WinLogon" -name DefaultPassword)
        $reg | Should Not BeNullOrEmpty
    }


    # Password never expires
    It "should never let password expire" {
        $svrname = $env:computername
        $user = ([adsi]"WinNT://$svrname/panuser")
        $Flags = $User.UserFlags.psbase.Value
        
        $expires = $true

        If ($Flags -band 65536) {
            # password does not expire
            $expires = $false
        }

        $expires | Should Be $false
    }

    # Disable Power connected state
    It "should set CsEnabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SYSTEM\CurrentControlSet\Control\Power" -name CsEnabled)
        $reg | Should Be "0"
    }


    # Disable UAC
    It "should set EnableLUA to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\Software\Microsoft\Windows\CurrentVersion\policies\system" -name EnableLUA)
        $reg | Should Be "0"
    }


    # no windows updates
    It "should have NoAutoUpdate set to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU" -name NoAutoUpdate)
        $reg | Should be "1"
    }


    It "should have AuOptions Windows Update value of 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU" -name AUOptions)
        $reg | Should be "1" 
    }


    # Turn off notifications
    It "should set EnableBalloonTips to 0" {
        $reg = (Get-ItemPropertyValue  "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer\Advanced" -name EnableBalloonTips)
        $reg | Should be "0"
    }

    # Kill hung services after 3 seconds
    It "should set WaitToKillServiceTimeout to 10000" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SYSTEM\CurrentControlSet\Control" -name WaitToKillServiceTimeout)
        $reg | Should be "10000"
    }


    # Remove the annoying clicking sound
    It "should set other WaitToKillServiceTimeout to empty string" {
        $reg = (Get-ItemPropertyValue  "HKCU:\AppEvents\Schemes\Apps\Explorer\Navigating\.Current" -name WaitToKillServiceTimeout)
        $reg | Should be ""
    }

    # turn off error reporting
    It "should set ErrorMode to 2" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SYSTEM\CurrentControlSet\Control\Windows" -name ErrorMode)
        $reg | Should be "2"
    }


    # No lock screen
    It "should set NoLockScreen to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\Software\Policies\Microsoft\Windows\Personalization\" -name NoLockScreen)
        $reg | Should Be "1"
    }


    # No driver search
    It "should set DontPromptForWindowsUpdate to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\Software\Policies\Microsoft\Windows\DriverSearching\" -name DontPromptForWindowsUpdate)
        $reg | Should Be "1"
    }


    # No notification center
    It "should set DisableNotificationCenter to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\Software\Policies\Microsoft\Windows\Explorer\" -name DisableNotificationCenter)
        $reg | Should Be "1"
    }


    # NoActiveHelp
    It "should set NoActiveHelp to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Assistance\Client\1.0" -name NoActiveHelp)
        $reg | Should Be "1"
    }


    # Cryptography paths
    It "should have Cryptography\Configuration\SSL\00010002\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Cryptography\Configuration\SSL\00010002\"
        $reg | Should Be $true
    }


    # IE Tabs
    It "should set IE AdvancedTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name AdvancedTab)
        $reg | Should Be "1"
    }

    It "should set IE ConnectionsTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name ConnectionsTab)
        $reg | Should Be "1"
    }
    
    It "should set IE ContentTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name ContentTab)
        $reg | Should Be "1"
    }
    
    It "should set IE GeneralTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name GeneralTab)
        $reg | Should Be "1"
    }
    
    It "should set IE PrivacyTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name PrivacyTab)
        $reg | Should Be "1"
    }
    
    It "should set IE ProgramsTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name ProgramsTab)
        $reg | Should Be "1"
    }
    
    It "should set IE SecurityTab to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Control Panel" -name SecurityTab)
        $reg | Should Be "1"
    }


    # Enable display mixed content
    It "should set Internet Settings\zones\2 1609 to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\Software\Microsoft\Windows\CurrentVersion\Internet Settings\zones\2" -name "1609")
        $reg | Should Be "0"
    }


    # Geolocation
    It "should PolicyDisableGeolocation to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Geolocation\" -name "PolicyDisableGeolocation")
        $reg | Should Be "1"
    }


    # Search box, JITSetup, Splash
    It "should set NoSearchBox to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Infodelivery\Restrictions" -name "NoSearchBox")
        $reg | Should Be "1"
    }

    It "should set NoJITSetup to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Infodelivery\Restrictions" -name "NoJITSetup")
        $reg | Should Be "1"
    }

    It "should set NoSplash to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Infodelivery\Restrictions" -name "NoSplash")
        $reg | Should Be "1"
    }


    # Linksbar
    It "should set IE linksbar Enabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\LinksBar" -name Enabled)
        $reg | Should Be "0"
    }


    # IE Main
    It "should set DisableFirstRunCustomize to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main" -name DisableFirstRunCustomize)
        $reg | Should Be "1"
    }
    
    It "should set NoReportSiteProblems to yes" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main" -name NoReportSiteProblems)
        $reg | Should Be "yes"
    }
    
    It "should set DoNotTrack to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main" -name DoNotTrack)
        $reg | Should Be "1"
    }
    
    It "should set GotoIntranetSiteForSingleWordEntry to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main" -name GotoIntranetSiteForSingleWordEntry)
        $reg | Should Be "0"
    }


    # IE EnterpriseMode
    It "should set ShowMessageWhenOpeningSitesInMicrosoftEdge to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main\EnterpriseMode" -name ShowMessageWhenOpeningSitesInMicrosoftEdge)
        $reg | Should Be "0"
    }


    # IE Lockdown
    It "should set LOCALMACHINE_CD_UNLOCK to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_LOCALMACHINE_LOCKDOWN\Settings" -name LOCALMACHINE_CD_UNLOCK)
        $reg | Should Be "0"
    }


    # IE FormatDetection
    It "should set PhoneNumberEnabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Main\FormatDetection" -name PhoneNumberEnabled)
        $reg | Should Be "0"
    }


    # IE Recovery
    It "should set AutoRecover to 2" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Recovery" -name AutoRecover)
        $reg | Should Be "2"
    }


    # IE Restrictions
    It "should set NoCrashDetection to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Restrictions" -name NoCrashDetection)
        $reg | Should Be "1"
    }
    
    It "should set NoHelpMenu to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Restrictions" -name NoHelpMenu)
        $reg | Should Be "1"
    }
    
    It "should set NoPrinting to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Restrictions" -name NoPrinting)
        $reg | Should Be "1"
    }


    # IE Security
    It "should set DisableFixSecuritySettings to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\Security" -name DisableFixSecuritySettings)
        $reg | Should Be "1"
    }


    # IE Zoom
    It "should set IE ZoomDisabled to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Internet Explorer\ZOOM" -name ZoomDisabled)
        $reg | Should Be "1"
    }


    # PCHealth Error Reporting
    It "should set PCHealth Error Reporting ShowUI to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\PCHealth\ErrorReporting" -name ShowUI)
        $reg | Should Be "1"
    }
    
    It "should set DWAllowHeadless to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\PCHealth\ErrorReporting\DW" -name DWAllowHeadless)
        $reg | Should Be "0"
    }


    # Peernet
    It "should set peernet Disabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Peernet" -name Disabled)
        $reg | Should Be "0"
    }


    # SQMClient
    It "should have SQMClient path" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SQMClient\"
        $reg | Should Be $true
    }


    # System Certificates
    It "should have SystemCertificates\CA\Certificates" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\CA\Certificates\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\CA\CRLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\CA\CRLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\CA\CTLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\CA\CTLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\Disallowed\Certificates\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\Certificates\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\Disallowed\CRLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\CRLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\Disallowed\CTLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\Disallowed\CTLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\Root\Certificates\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\Certificates\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\Root\CRLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\CRLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\Root\CTLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\Root\CTLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\trust\Certificates\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\trust\Certificates\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\trust\CRLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\trust\CRLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\trust\CTLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\trust\CTLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\TrustedPeople\Certificates\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\TrustedPeople\Certificates\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\TrustedPeople\CRLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\TrustedPeople\CRLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\TrustedPeople\CTLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\TrustedPeople\CTLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\TrustedPublisher\Certificates\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\TrustedPublisher\Certificates\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\TrustedPublisher\CRLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\TrustedPublisher\CRLs\"
        $reg | Should Be $true
    }
    
    It "should have SystemCertificates\TrustedPublisher\CTLs\" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\SystemCertificates\TrustedPublisher\CTLs\"
        $reg | Should Be $true
    }


    # TabletPC
    It "should have PreventFlicks set to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\TabletPC" -name PreventFlicks)
        $reg | Should Be "1"
    }

    It "should have PreventButtonPressAndHold set to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\TabletPC" -name PreventButtonPressAndHold)
        $reg | Should Be "1"
    }


    # TabletTip
    It "should have DisableEdgeTarget set to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\TabletTip\1.7" -name DisableEdgeTarget)
        $reg | Should Be "1"
    }


    # TPM
    It "should set TPM OSManagedAuthLevel to 2" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\TPM" -name OSManagedAuthLevel)
        $reg | Should Be "2"
    }


    # Windows Appx, BITS, CloudContent
    It "should set DisableSoftLanding to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent" -name DisableSoftLanding)
        $reg | Should Be "1"
    }
    
    It "should set DisableWindowsConsumerFeatures to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent" -name DisableWindowsConsumerFeatures)
        $reg | Should Be "1"
    }


    # Windows CurrentVersion
    It "should have an internet settings cache registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CurrentVersion\Internet Settings\Cache\"
        $reg | Should Be $true
    }


    # Windows DataCollection
    It "should set DoNotShowFeedbackNotifications to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DataCollection" -name DoNotShowFeedbackNotifications)
        $reg | Should Be "1"
    }


    # Windows CurrentVersion
    It "should have delivery optimization registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DeliveryOptimization\"
        $reg | Should Be $true
    }


    # Windows DeviceInstall
    It "should set DisableBalloonTips to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DeviceInstall\Settings" -name DisableBalloonTips)
        $reg | Should Be "1"
    }
    
    It "should set DisableSystemRestore to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DeviceInstall\Settings" -name DisableSystemRestore)
        $reg | Should Be "1"
    }
    
    It "should set DisableSendGenericDriverNotFoundToWER to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DeviceInstall\Settings" -name DisableSendGenericDriverNotFoundToWER)
        $reg | Should Be "1"
    }


    # Windows DriverSearching
    It "should set DontPromptForWindowsUpdate to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DriverSearching" -name DontPromptForWindowsUpdate)
        $reg | Should Be "1"
    }


    # Windows DWM
    It "should set DisallowAnimations to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DWM" -name DisallowAnimations)
        $reg | Should Be "1"
    }
    
    It "should set DisallowFlip3d to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\DWM" -name DisallowFlip3d)
        $reg | Should Be "1"
    }


    # Edge UI
    It "should set AllowEdgeSwipe to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\EdgeUI" -name AllowEdgeSwipe)
        $reg | Should Be "0"
    }
    
    It "should set DisableHelpSticker to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\EdgeUI" -name DisableHelpSticker)
        $reg | Should Be "1"
    }


    # Enhanced Storage Devices
    It "should set TCGSecurityActivationDisabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\EnhancedStorageDevices" -name TCGSecurityActivationDisabled)
        $reg | Should Be "0"
    }


    # Windows Explorer
    It "should set NoAutoplayfornonVolume to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Explorer" -name NoAutoplayfornonVolume)
        $reg | Should Be "1"
    }


    # GameUX
    It "should set GameUpdateOptions to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\GameUX" -name GameUpdateOptions)
        $reg | Should Be "0"
    }


    # Windows HomeGroup
    It "should set DisableHomeGroup to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\HomeGroup" -name DisableHomeGroup)
        $reg | Should Be "1"
    }


    # IPSec
    It "should have IPSec registry keys" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\IPSec\Policy\Local\"
        $reg | Should Be $true
    }


    # Network Connections
    It "should have NC_PersonalFirewallConfig set to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Network Connections" -name NC_PersonalFirewallConfig)
        $reg | Should Be "0"
    }


    # Network Connectivity Status Indicator
    It "should have an empty default networkconnectivitystatusindicator" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\NetworkConnectivityStatusIndicator" -name "(default)")
        $reg | Should Be ""
    }


    # Network Provider
    It "should have a network provider registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\NetworkProvider\HardenedPaths\"
        $reg | Should Be $true
    }


    # OneDrive
    It "should set DisableFileSyncNGSC to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\OneDrive" -name DisableFileSyncNGSC)
        $reg | Should Be "1"
    }


    # Removable Storage Devices
    It "should set Deny_All to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\RemovableStorageDevices" -name Deny_All)
        $reg | Should Be "1"
    }


    # Code Identifiers
    It "should set authenticodeenabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\safer\codeidentifiers" -name authenticodeenabled)
        $reg | Should Be "0"
    }


    # Setting Sync
    It "should set EnableBackupForWin8Apps to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\SettingSync" -name EnableBackupForWin8Apps)
        $reg | Should Be "1"
    }
    
    It "should set DisableSettingSync to 2" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\SettingSync" -name DisableSettingSync)
        $reg | Should Be "2"
    }
    
    It "should set DisableSettingSyncUserOverride to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\SettingSync" -name DisableSettingSyncUserOverride)
        $reg | Should Be "1"
    }


    # Windows System
    It "should set BlockUserFromShowingAccountDetailsOnSignin to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\System" -name BlockUserFromShowingAccountDetailsOnSignin)
        $reg | Should Be "1"
    }
    
    It "should set SlowLinkDetectEnabled to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\System" -name SlowLinkDetectEnabled)
        $reg | Should Be "0"
    }
    
    It "should set DisplayNetworkSelectionUI to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\System" -name DontDisplayNetworkSelectionUI)
        $reg | Should Be "1"
    }


    # WcmSvc
    It "should set WCMPresent to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WcmSvc\Local" -name WCMPresent)
        $reg | Should Be "1"
    }


    # Windows Error Reporting
    It "should set DontShowUI to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Error Reporting" -name DontShowUI)
        $reg | Should Be "1"
    }
    
    It "should set Disabled to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Error Reporting" -name Disabled)
        $reg | Should Be "1"
    }


    # WER Consent
    It "should set WER DefaultConsent to 4" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Error Reporting\Consent" -name DefaultConsent)
        $reg | Should Be "4"
    }


    # Windows Update
    It "should set NoAutoUpdate to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU" -name NoAutoUpdate)
        $reg | Should Be "1"
    }
    
    It "should set NoAUShutdownOption to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU" -name NoAUShutdownOption)
        $reg | Should Be "1"
    }


    # Workplace Join
    It "should set WorkplaceJoin default to empty" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WorkplaceJoin" -name "(Default)")
        $reg | Should Be ""
    }


    # WDSAPI
    It "should have a WSDAPI registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WSDAPI\"
        $reg | Should Be $true
    }
    
    It "should have a SDAPI\Discovery Proxies registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\WSDAPI\Discovery Proxies\"
        $reg | Should Be $true
    }


    # Windows Advances Threat Protection
    It "should have a Windows Advanced Threat Protection registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Advanced Threat Protection\"
        $reg | Should Be $true
    }


    # Windows Defender
    It "should have a Windows Defender registry key" {
        $reg = Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows Defender\Policy Manager\"
        $reg | Should Be $true
    }


    # Windows NT IIS
    It "should set PreventIISInstall to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\IIS" -name PreventIISInstall)
        $reg | Should Be "1"
    }


    # Windows NT System Restore
    It "should set DisableSR to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\SystemRestore" -name DisableSR)
        $reg | Should Be "1"
    }


    # Windows NT Terminal Services
    It "should set fEnableUsbBlockDeviceBySetupClass to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Terminal Services\Client" -name fEnableUsbBlockDeviceBySetupClass)
        $reg | Should Be "1"
    }
    
    It "should set fEnableUsbNoAckIsochWriteToDevice to 50" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Terminal Services\Client" -name fEnableUsbNoAckIsochWriteToDevice)
        $reg | Should Be "50"
    }
    
    It "should set fEnableUsbSelectDeviceByInterface to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Terminal Services\Client" -name fEnableUsbSelectDeviceByInterface)
        $reg | Should Be "1"
    }


    # USB Block Device by Setup Classes
    It "should set UsbBlockDeviceBySetupClasses\1000 to {3376f4ce-ff8d-40a2-a80f-bb4359d1415c}" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Terminal Services\Client\UsbBlockDeviceBySetupClasses" -name 1000)
        $reg | Should Be "{3376f4ce-ff8d-40a2-a80f-bb4359d1415c}"
    }


    # USB Select Device By Interfaces
    It "should set UsbSelectDeviceByInterfaces\1000 to {6bdd1fc6-810f-11d0-bec7-08002be2092f}" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Terminal Services\Client\UsbSelectDeviceByInterfaces\" -name 1000)
        $reg | Should Be "{6bdd1fc6-810f-11d0-bec7-08002be2092f}"
    }


    # Windows File Protection
    It "should set knownDllList to nlhtml.dll" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Windows File Protection" -name KnownDllList)
        $reg | Should Be "nlhtml.dll"
    }
    
    It "should set SfcShowProgress to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\Windows\Windows NT\Windows File Protection" -name SfcShowProgress)
        $reg | Should Be "0"
    }


    # Windows Media Player
    It "should set GroupPrivacyAcceptance to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\WindowsMediaPlayer" -name GroupPrivacyAcceptance)
        $reg | Should Be "1"
    }
    
    It "should set DisableAutoUpdate to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\WindowsMediaPlayer" -name DisableAutoUpdate)
        $reg | Should Be "1"
    }


    # Windows Store
    It "should set AutoDownload to 2" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Policies\Microsoft\WindowsStore" -name AutoDownload)
        $reg | Should Be "2"
    }


    # Disable touch and hold right click
    It "should set TouchMode_hold to 0" {
        $reg = (Get-ItemPropertyValue  "HKCU:\Software\Microsoft\Wisp\Touch" -name TouchMode_hold)
        $reg | Should Be "0"
    }


    # No logon screen background image
    It "should set DisableLogonBackgroundImage to 1" {
        $reg = (Get-ItemPropertyValue "HKLM:\Software\Policies\Microsoft\Windows\System" -name DisableLogonBackgroundImage)
        $reg | Should Be "1"
    }


    # System Tray
    It "should set EnableAutoTray to 0" {
        $reg = (Get-ItemPropertyValue  "HKCU:\Software\Microsoft\Windows\CurrentVersion\Explorer" -name EnableAutoTray)
        $reg | Should Be "0"
    }
}