Describe "Panacea Registry Key/Values" {
#add regisrty
    It "should have correct terminal server" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea" -name TerminalServer)
        $reg | Should Be "http://management.i3panacea.com:1337"
    }

    It "should have RuntimePath set to empty string" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea" -name RuntimePath)
        $reg | Should Be ""
    }

    It "should have Panacea\Launcher Disabled set to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher" -name Disabled)
        $reg | Should Be "0"
    }

#Launcher ProcessName
    It "should have Panacea\Launcher\Processes\Panacea Panacea set to Panacea.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher\Processes\Panacea" -name Panacea)
        $reg | Should Be "Panacea.exe"
    }

    It "should have Panacea\Launcher\Processes\Panacea IBT.Updater set to Updater\IBT.Updater.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher\Processes\Panacea" -name IBT.Updater)
        $reg | Should Be "Updater\IBT.Updater.exe"
    }

    It "should have Panacea\Launcher\Processes\Panacea PanaceaRegistrator set to Updater\PanaceaRegistrator.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher\Processes\Panacea" -name PanaceaRegistrator)
        $reg | Should Be "Updater\PanaceaRegistrator.exe"
    }

    It "should have Panacea\Launcher\Processes\Panacea Default set to Panacea.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher\Processes\Panacea" -name "(Default)")
        $reg | Should Be "Panacea.exe"
    }

#servercommunicator
    It "should have Panacea\Launcher\Processes\ServerCommunicator ServerCommunicator set to ServerCommunicator.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher\Processes\ServerCommunicator" -name ServerCommunicator)
        $reg | Should Be "ServerCommunicator.exe"
    }

    It "should have Panacea\Launcher\Processes\ServerCommunicator Default set to ServerCommunicator.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Launcher\Processes\ServerCommunicator" -name "(Default)")
        $reg | Should Be "ServerCommunicator.exe"
    }

#Systemsetup
    It "should have Panacea\SystemSetup\Applications Explorer set to c:\Windows\explorer.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name Explorer)
        $reg | Should Be "c:\Windows\explorer.exe"
    }

    It "should have Panacea\SystemSetup\Applications Command Prompt set to c:\Windows\System32\cmd.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name "Command Prompt")
        $reg | Should Be "c:\Windows\System32\cmd.exe"
    }

    It "should have Panacea\SystemSetup\Applications Event Viewer set to c:\Windows\System32\eventvwr.msc" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name "Event Viewer")
        $reg | Should Be "c:\Windows\System32\eventvwr.msc"
    }

    It "should have Panacea\SystemSetup\Applications Control Panel set to c:\Windows\System32\control.exe" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name "Control Panel")
        $reg | Should Be "c:\Windows\System32\control.exe"
    }

    It "should have Panacea\SystemSetup\Applications Computer Management set to c:\Windows\System32\compmgmt.msc" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name "Computer Management")
        $reg | Should Be "c:\Windows\System32\compmgmt.msc"
    }

    It "should have Panacea\SystemSetup\Applications Performance Monitor set to c:\Windows\System32\perfmon.msc" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name "Performance Monitor")
        $reg | Should Be "c:\Windows\System32\perfmon.msc"
    }

    It "should have Panacea\SystemSetup\Applications Device Manager set to c:\Windows\System32\devmgmt.msc" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\SystemSetup\Applications" -name "Device Manager")
        $reg | Should Be "c:\Windows\System32\devmgmt.msc"
    }

#System
    It "should have Panacea\Updater ContinuousFailures set to 1" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SOFTWARE\Panacea\Updater" -name "ContinuousFailures")
        $reg | Should Be "1"
    } 
}