Describe "Power Settings" {
    
    It "should be set to high performance" {
        $power = Get-CimInstance -N root\cimv2\power -Class win32_PowerPlan | select ElementName, IsActive | where ElementName -match "High performance"
        $power.IsActive | Should Be "true"
    }


# LID CLOSED
    It "should do nothing when lid closed, on battery" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 5ca83367-6e45-459f-a27b-476b1d01c936
        $power.GetValue(14) | Should BeLike "* Current AC Power Setting Index: 0x00000000"
    }

    It "should do nothing when lid closed, plugged in" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 5ca83367-6e45-459f-a27b-476b1d01c936
        $power.GetValue(15) | Should BeLike "* Current DC Power Setting Index: 0x00000000"
    }


# POWER BUTTON
    It "should do nothing when power button pressed, on battery" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 7648efa3-dd9c-4e3e-b566-50f929386280
        $power.GetValue(16) | Should BeLike "* Current AC Power Setting Index: 0x00000000"
    }

    It "should do nothing when power button pressed, plugged in" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 7648efa3-dd9c-4e3e-b566-50f929386280
        $power.GetValue(17) | Should BeLike "* Current DC Power Setting Index: 0x00000000"
    }


# SLEEP BUTTON
    It "should do nothing when sleep button pressed, on battery" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 96996bc0-ad50-47ec-923b-6f41874dd9eb
        $power.GetValue(16) | Should BeLike "* Current AC Power Setting Index: 0x00000000"
    }

    It "should do nothing when sleep button pressed, plugged in" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 4f971e89-eebd-4455-a8de-9e59040e7347 96996bc0-ad50-47ec-923b-6f41874dd9eb
        $power.GetValue(17) | Should BeLike "* Current DC Power Setting Index: 0x00000000"
    }


# HARD DISK
    It "should never turn off the hard disk, on battery" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 0012ee47-9041-4b5d-9b77-535fba8b1442 6738e2c4-e8a5-4a42-b16a-e040e769756e
        $power.GetValue(10) | Should BeLike "* Current AC Power Setting Index: 0x00000000"
    }

    It "should never turn off the hard disk, plugged in" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 0012ee47-9041-4b5d-9b77-535fba8b1442 6738e2c4-e8a5-4a42-b16a-e040e769756e
        $power.GetValue(11) | Should BeLike "* Current DC Power Setting Index: 0x00000000"
    }


# DISPLAY
    It "should never turn off the hard disk, on battery" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 7516b95f-f776-4464-8c53-06167f40cc99 3c0bc021-c8a8-4e07-a973-6b14cbcb2b7e
        $power.GetValue(10) | Should BeLike "* Current AC Power Setting Index: 0x00000000"
    }

    It "should never turn off the hard disk, plugged in" {
        $power = powercfg -query 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c 7516b95f-f776-4464-8c53-06167f40cc99 3c0bc021-c8a8-4e07-a973-6b14cbcb2b7e
        $power.GetValue(11) | Should BeLike "* Current DC Power Setting Index: 0x00000000"
    }
}