$computer = Get-WmiObject -class Win32_Computersystem | Select-Object manufacturer, model;

if ($computer.model -eq "Medi-Link 18.5 (REM-ML-EKAB-001)") {
    function Get-Applications {
        if($env:PROCESSOR_ARCHITECTURE -eq "AMD64"){
            $application_registry = "HKLM:\Software\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\*"
        }else{
            $application_registry = "HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\*"
        }
        
        return Get-ItemProperty $application_registry
    }


    Describe "Remedi Drivers" {
        
        $applications = Get-Applications;

        # It "should have Realtek Ethernet Controller Driver" {
        #     $applications | Where-Object DisplayName -match "Realtek Ethernet Controller Driver" | Should Not BeNullOrEmpty
        # }

        # It "should have Realtek High Definition Audio Driver" {
        #     $applications | where-object DisplayName -Match "Realtek High Definition Audio Driver" | Should Not BeNullOrEmpty
        # }


        It "Viper Installed" {
            Test-Path "C:\Program Files\ViPER4Windows" | Should Be $true
        }

        # It "should have EZUSB Driver (Smart Card)" {
        #     $applications | where-object DisplayName -Match "EZUSB Driver" | Should Not BeNullOrEmpty
        # }

        It "should have AMD display driver" {
            $amd = get-pnpdevice | where-object FriendlyName -match "Radeon" | Where-Object class -match "Display" | Should Not BeNullOrEmpty
        }

        # It "should have HID Global USB CDC EEM Driver" {
        #     $applications | where-object DisplayName -Match "HID Global USB CDC EEM Driver" | Should Not BeNullOrEmpty
        # }
    }
}