Describe "Scheduled Tasks" {

    It "should not have OneDrive tasks scheduled" {
        $schTask = Get-ScheduledTask | Where {$_.TaskName -match "OneDrive"}

        if($schTask) {
            $schTask.State | Should Be "disabled"
        }
    }

    It "should have no Adobe tasks scheduled" {

        $schTask = Get-ScheduledTask | Where-Object {$_.TaskName -match "adobe"}

        if($schTask) {
            $schTask.State | Should Be "Disabled"
        }
    }

    It "should have no Klite tasks scheduled" {

        $schTask = Get-ScheduledTask | Where-Object {$_.TaskName -match "klite"}

        if($schTask){
            $schTask.State | Should Be "Disabled"
        }
    }
   

    It "should have Super Update Time tasks scheduled" {

        $schTask =(Get-ScheduledTask | Where-Object {$_.TaskName -match "Super Update Time" })

        if($schTask){
            $schTask.Settings.Enabled | Should Be $true
        }
    }     

    It "should have no WinSAT tasks scheduled" {

        $schTask =(Get-ScheduledTask | Where-Object {$_.TaskName -match "WinSAT" })

        if($schTask){
            $schTask[0].Settings.Enabled | Should Be $false
        }
    }      

    It "should have Reboot On logoff tasks scheduled" {

        $schTask =(Get-ScheduledTask | Where-Object {$_.TaskName -match "Reboot On logoff" })

        if($schTask){
            $schTask.Settings.Enabled | Should Be $true
        }
    } 
}