Describe "Services" {

    It "should not have windows update running" {
        $service = Get-Service | Where {$_.Name -match "wuauserv"}
        $service.StartType | Should Be "disabled"
    }

    It "should have no Adobe Services Running" {

        $services = Get-Service | Where-Object {$_.Name -match "adobe" -or $_.DisplayName -match "adobe"}
        if ($services) {
            $services.StartType | Should Be "Disabled"
        }
    }

    It "should have no Klite Services Running" {

        $services = Get-Service | Where-Object {$_.Name -match "klite" -or $_.DisplayName -match "klite"}

        if ($services) {
            $services.StartType | Should Be "Disabled"
        }
    }

    It "should have no Skype Services Running" {

        $services = Get-Service | Where-Object {$_.Name -match "Skype" -or $_.DisplayName -match "Skype"}

        if ($services) {
            $services.StartType | Should Be "Disabled"
        }
    }

    It "should have no Sensor Services Running" {

        $services = Get-Service | Where-Object {$_.Name -match "Sensor Service" -or $_.DisplayName -match "Sensor Service"}

        if ($services) {
            $services.StartType | Should Be "Disabled"
        }
    }

    # this isn't a service, but I wasn't sure where to put it so I put it with the sensor service in s_services
    if (gwmi -Query 'select product from win32_baseboard where product="Surface Pro 3"') {
        It "should disable device driver that senses rotation" {
            $rotate = get-pnpdevice | where-object { $_.friendlyname -eq "HID Sensor Collection V2" }
            $rotate.status | Should Be "error"
        }
    }
    

    It "should have no XBox Services Running" {

        $services = Get-Service | Where-Object {$_.Name -match "xbox" -or $_.DisplayName -match "xbox"}

        if ($services) {
            $services.StartType | Should Be "Disabled"
        }
    }

    # These aren't services, but they are from the s_services file, so they're going here.
    It "should have fDenyTSConnections set to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SYSTEM\CurrentControlSet\Control\Terminal Server" -name fDenyTSConnections)
        $reg | Should be "0"
    }

    It "should have UserAuthentication set to 0" {
        $reg = (Get-ItemPropertyValue  "HKLM:\SYSTEM\CurrentControlSet\Control\Terminal Server\WinStations\RDP-Tcp" -name UserAuthentication)
        $reg | Should be "0"
    }

    It "should have RDP enabled in Firewall" {
        $firewall = get-NetFirewallRule -DisplayGroup 'Remote Desktop'
        foreach ($rule in $firewall) {
            $rule.action | Should be "Allow"
        }
    }


    # It "Should have Windows Defender Realtime Monitoring Disabled" {
    #     (Get-MpPreference).DisableRealtimeMonitoring | Should be $true
    # }
}