
Describe "Testing Registry API" {


    BeforeAll {
        $nonDefaultFilePath = "C:\windows\Logs\Window_10_Setup\buildNonDefault.log"
        $modulesToTestAndDependencies = @("Logger", "FileNetworkDownloadAndScheduledTaskHelpers") 
        Import-Module $modulesToTestAndDependencies -DisableNameChecking
        $logger = Get-Logger "Add-Registry test" $nonDefaultFilePath
        $paths = @("HKLM:\SOFTWARE\DeleteMe1\DeleteMe11", "HKLM:\SOFTWARE\DeleteMe2\DeleteMe21")
    }

    AfterAll {
        Remove-Module $modulesToTestAndDependencies
    }

    Context "Add-RegistryKeys" {

        AfterAll {
            foreach ($path in $paths) {
                Remove-Item -Path $path
            }
        }


        it "should add registry keys that don't exist" {
            Add-RegistryKeys $paths $logger
            foreach ($path in $paths) {
                (Test-Path $path) | should be true
            }
        }
    
        #this test depends on the previous one
        it "Should not add registry keys that do exist" {
            # This will ensure that Add-Registry throws an error if it attempts to create a key that already exists.
            $originalErrorActionPreference = $ErrorActionPreference
            $ErrorActionPreference = "Stop"
    
            { Add-RegistryKeys $paths $logger } | Should not throw
            $ErrorActionPreference = $originalErrorActionPreference        
        }
    }

    Context "Add-RegistryKey" {

        AfterAll {
            Remove-Item -Path $paths[0]    
        }

        it "should add a registry key that does not exist" {
            Add-RegistryKey $paths[0] $logger
            Test-Path $paths[0] | should be true
        }

        it "Should not add registry key that do exist" {
            # This will ensure that Add-Registry throws an error if it attempts to create a key that already exists.
            $originalErrorActionPreference = $ErrorActionPreference
            $ErrorActionPreference = "Stop"
    
            { Add-RegistryKeys $paths[0] $logger } | Should not throw
            $ErrorActionPreference = $originalErrorActionPreference        
        }
    }   
}


