
Describe "Testing Download-File and Download-Unzip" {
    $logger = Get-Logger "Download-File and Download-Unzip test"
    $serverAddress = "http://image.i3panacea.com"
    $testingFolder = "C:\testing1\testing2"
    it "Should download the file and save it where specified" {
        
        $testingFile = "$testingFolder\test.txt"
        Download-File "$serverAddress/ps1.txt" $testingFile $logger

        (Test-Path $testingFile) | should be true

        Remove-Item $testingFolder -Recurse
    }

    it "Should download and unzip the file" {
        $zipFile="ps1.zip"
        $testingFolder = "C:\testing"

        Download-Unzip "$serverAddress/$zipFile" $testingFolder $logger

        (Test-Path $testingFolder\ps1.txt) | should be true 

        Remove-Item $testingFolder -Recurse
    }

    it "Should download and unzip the file with retries" {
        $zipFile="ps1.zip"
        $testingFolder = "C:\testing"

        Download-Unzip "$serverAddress/$zipFile" $testingFolder $logger 10

        (Test-Path $testingFolder\ps1.txt) | should be true 

        Remove-Item $testingFolder -Recurse
    }

}