Describe "Environmental Variables Persistance" {

    BeforeAll {
        $value = [System.Environment]::GetEnvironmentVariable("I3Test", [System.EnvironmentVariableTarget]::Machine)
        $value | Should BeNullOrEmpty 
    }

    $tempenv = "I3Test"
    [System.Environment]::SetEnvironmentVariable("I3Test", "1", "Machine")
    

    AfterAll {
        [System.Environment]::SetEnvironmentVariable("I3Test","", "Machine")
    }


    it "Should have test env defined" {
        $value = [System.Environment]::GetEnvironmentVariable($tempenv, [System.EnvironmentVariableTarget]::Machine)
        $value| Should Be "1" 
    }


    
    Start-Job {
        $tempenv = "I3Test"
        describe "Environmental Variables Persistance Inside Job" {

            it "Should have test env defined" {
                $value = [System.Environment]::GetEnvironmentVariable("I3Test", [System.EnvironmentVariableTarget]::Machine)
                $value| Should Be "1"
            }

            it "Should not have session ENV Variable defined" {
                $env:I3Test | Should BeNullOrEmpty
            }
        }

            
    } | Receive-Job -AutoRemoveJob -Wait
    
}