
Describe "PowerShell Modules Installed Tests" {
    $moduleNames = @("FileNetworkDownloadAndScheduledTaskHelpers", "InstallUninstallHelpers", "KioskConfig", "Logger", "PowerSettings", 
        "PowerShellConfig", "PSWindowsUpdate", "RunTests"
    )
    foreach ($moduleName in $moduleNames) {
        It "should have module $moduleName installed" {
            Import-Module $moduleName
            $ret = Get-Module $moduleName
            $ret | Should Not BeNullOrEmpty
            Remove-Module $moduleName
        }
    }
}


Describe "PowerShell Modules Functional Tests" {
    BeforeAll {
        Push-Location .
    }
    AfterAll {
        Pop-Location
    }
    $moduleName = "PowerShellConfig"   
    Context "$moduleName Functional Tests" {
        BeforeAll {
            Import-Module $moduleName
        }
        AfterAll {
            Remove-Module $moduleName 
        }
        $function = "Set-ParentScopeVariable"
        $value = "Stop"
        $varName = "`$ErrorActionPreference"
        It "$function should set $varName to ""$value"" and return previous " { 
            $ErrorActionPreference = "test"     
            $prev = Set-ParentScopeVariable([ref] $ErrorActionPreference) $value
            $ErrorActionPreference | Should Be $value
            Set-ParentScopeVariable([ref] $ErrorActionPreference) $prev
            $ErrorActionPreference | Should Be $prev
        }
    }
    $moduleName = "Logger"
    # Don't uncomment the test of Default Log File Path so that it will not delete the build.log when run as part of Run-Tests
    # $defaultFilePath = "C:\windows\Logs\Window_10_Setup\build.log"
    $nonDefaultFilePath = "C:\windows\Logs\Window_10_Setup\buildNonDefault.log"
    # Context "$moduleName Functional Tests with Default Log File Path" {
    #     BeforeAll {
    #         if(Test-Path $defaultFilePath){
    #             Remove-Item $defaultFilePath
    #         }
    #         $ret = Get-Module $moduleName
    #         if($ret){
    #             Remove-Module $moduleName
    #         }         
    #         Import-Module $moduleName
    #         $nameSpace = "LoggerTest"
    #         $logger = Get-Logger $nameSpace      
    #         $infoMsg = "Test Info Message"
    #         $logger.Info($infoMsg)
    #         $infoDate = Get-Date -f $logger.dateformat
    #         $warnMsg = "Test Warn Message"
    #         $logger.Warn($warnMsg)
    #         $warnDate = Get-Date -f $logger.dateformat
    #         $errorMsg = "Test Error Message"
    #         $logger.Error($errorMsg)
    #         $errorDate = Get-Date -f $logger.dateformat
    #         $lines = Get-Content $defaultFilePath
    #     }
    #     AfterAll {
    #         if(Test-Path $defaultFilePath){
    #             Remove-Item $defaultFilePath
    #         }
    #         Remove-Module $moduleName 
    #     }
    #     It "Logger.Info should write Info Message"{
    #         $tokens = $lines[0].Split($logger.separator);
    #         $date = $tokens[0].Split(" ");
    #         $date[0] | Should Be $infoDate
    #         $tokens[1] | Should be $nameSpace
    #         $tokens[2] | Should be "Info:$infoMsg"
    #     }
    #     It "Logger.Warn should write Warn Message"{
    #         $tokens = $lines[1].Split($logger.separator);
    #         $date = $tokens[0].Split(" ");
    #         $date[0] | Should Be $warnDate
    #         $tokens[1] | Should be $nameSpace
    #         $tokens[2] | Should be "Warn:$warnMsg"
    #     }
    #     It "Logger.Error should write Error Message"{
    #         $tokens = $lines[2].Split($logger.separator);
    #         $date = $tokens[0].Split(" ");
    #         $date[0] | Should Be $errorDate
    #         $tokens[1] | Should be $nameSpace
    #         $tokens[2] | Should be "Error:$errorMsg"
    #     }
    # }

    Context "$moduleName Functional Tests with NonDefault Log File Path, with Mutex" {
        BeforeAll {
            if (Test-Path $nonDefaultFilePath) {
                Remove-Item $nonDefaultFilePath
            }
            $ret = Get-Module $moduleName
            if ($ret) {
                Remove-Module $moduleName
            }         
            Import-Module $moduleName
            $nameSpace = "LoggerTest"
            $logger = Get-Logger $nameSpace $nonDefaultFilePath    
            $infoMsg = "Test Info Message"
            $logger.Info($infoMsg)
            $infoDate = Get-Date -f $logger.dateformat
            $warnMsg = "Test Warn Message"
            $logger.Warn($warnMsg)
            $warnDate = Get-Date -f $logger.dateformat
            $errorMsg = "Test Error Message"
            $logger.Error($errorMsg)
            $errorDate = Get-Date -f $logger.dateformat
            $lines = Get-Content $nonDefaultFilePath
        }
        AfterAll {
            if (Test-Path $nonDefaultFilePath) {
                Remove-Item $nonDefaultFilePath
            }
            Remove-Module $moduleName 
        }

        It "Should Create Logger With Mutex" {
            $logger = Get-Logger $namespace $nonDefaultFilePath
            $logger.Info("Test Info")
            $logger.namespace | Should Be $namespace
            $logger.mutex | Should Not Be $null
        }

        It "Logger.Info should write Info Message" {
            $tokens = $lines[0].Split($logger.separator);
            $date = $tokens[0].Split(" ");
            $date[0] | Should Be $infoDate
            $tokens[1] | Should be $nameSpace
            $tokens[2] | Should be "Info:$infoMsg"
        }
        It "Logger.Warn should write Warn Message" {
            $tokens = $lines[1].Split($logger.separator);
            $date = $tokens[0].Split(" ");
            $date[0] | Should Be $warnDate
            $tokens[1] | Should be $nameSpace
            $tokens[2] | Should be "Warn:$warnMsg"
        }
        It "Logger.Error should write Error Message" {
            $tokens = $lines[2].Split($logger.separator);
            $date = $tokens[0].Split(" ");
            $date[0] | Should Be $errorDate
            $tokens[1] | Should be $nameSpace
            $tokens[2] | Should be "Error:$errorMsg"
        }
    }

    Context "$moduleName Functional Tests with NonDefault Log File Path, without Mutex" {
        BeforeAll {
            if (Test-Path $nonDefaultFilePath) {
                Remove-Item $nonDefaultFilePath
            }
            $ret = Get-Module $moduleName
            if ($ret) {
                Remove-Module $moduleName
            }         
            Import-Module $moduleName
            $nameSpace = "LoggerTest"
            $logger = Get-Logger $nameSpace $nonDefaultFilePath -NoMutex    
            $infoMsg = "Test Info Message"
            $logger.Info($infoMsg)
            $infoDate = Get-Date -f $logger.dateformat
            $warnMsg = "Test Warn Message"
            $logger.Warn($warnMsg)
            $warnDate = Get-Date -f $logger.dateformat
            $errorMsg = "Test Error Message"
            $logger.Error($errorMsg)
            $errorDate = Get-Date -f $logger.dateformat
            $lines = Get-Content $nonDefaultFilePath
        }
        AfterAll {
            if (Test-Path $nonDefaultFilePath) {
                Remove-Item $nonDefaultFilePath
            }
            Remove-Module $moduleName 
        }
    
        It "Should Create Logger Without Mutex" {
            $logger = Get-Logger $namespace $nonDefaultFilePath -NoMutex
            $logger.Info("Test Info")
            $logger.namespace | Should Be $namespace
            $logger.mutex | Should Be $null
        }

        It "Logger.Info should write Info Message" {
            $tokens = $lines[0].Split($logger.separator);
            $date = $tokens[0].Split(" ");
            $date[0] | Should Be $infoDate
            $tokens[1] | Should be $nameSpace
            $tokens[2] | Should be "Info:$infoMsg"
        }
        It "Logger.Warn should write Warn Message" {
            $tokens = $lines[1].Split($logger.separator);
            $date = $tokens[0].Split(" ");
            $date[0] | Should Be $warnDate
            $tokens[1] | Should be $nameSpace
            $tokens[2] | Should be "Warn:$warnMsg"
        }
        It "Logger.Error should write Error Message" {
            $tokens = $lines[2].Split($logger.separator);
            $date = $tokens[0].Split(" ");
            $date[0] | Should Be $errorDate
            $tokens[1] | Should be $nameSpace
            $tokens[2] | Should be "Error:$errorMsg"
        }
    }
}

#Long Running Test - this is why they are outside other functional tests
Describe "Log Written From Concurrent Jobs" {
    $namespace = "ConcurrentBuildLogTest"
    $logFileBasePath = "C:\windows\Logs\Window_10_Setup"
    $logFilePath = "$logFileBasePath\$namespace.log"
    $orignalErrorActionPreference =  $ErrorActionPreference
    $ErrorActionPreference = "Stop"
    [string]$originalLocation = Get-Location

    BeforeAll {
        $originalLocation = Get-Location
        $orignalErrorActionPreference =  $ErrorActionPreference
        $ErrorActionPreference = "Stop"
        Import-Module Logger
    }
    AfterAll {
        Remove-Module Logger
        $ErrorActionPreference = $orignalErrorActionPreference
        Get-Job | Remove-Job
        # TODO: fails, with
        # [-] Error occurred in test script 'e:\Code\Panacea-Image\Win10_LTBS_2016_builder\Win10FirstRun\test\default\PowerShellModules.Tests.ps1' 28ms
        # ParameterBindingValidationException: Cannot bind argument to parameter 'Path' because it is null.
        # at <ScriptBlock>, E:\Code\Panacea-Image\Win10_LTBS_2016_builder\Win10FirstRun\test\default\PowerShellModules.Tests.ps1: line 239
        # at Invoke-Blocks, C:\Program Files\WindowsPowerShell\Modules\Pester\3.4.0\Functions\SetupTeardown.ps1: line 134
        # at Invoke-TestGroupTeardownBlocks, C:\Program Files\WindowsPowerShell\Modules\Pester\3.4.0\Functions\SetupTeardown.ps1: line 124
        
        #report case to Pester maintainers or update version
        # if (Test-Path $logFilePath) {
        #     Remove-Item $logFilePath
        # }
        Set-Location $originalLocation   
    }

    BeforeEach {
        Get-Job | Remove-Job
        if (Test-Path $logFilePath) {
            Remove-Item $logFilePath
        }   
    }

    AfterEach {
        Get-Job | Remove-Job
        if (Test-Path $logFilePath) {
            Remove-Item $logFilePath
        } 
    }

    It "Wrting from parallel jobs to one file without mutex should throw" {
        $testScriptBlock = {
            $jobScriptBlock = {
                param($jobName)
                $namespace = "ConcurrentBuildLogTest"
                $logFileBasePath = "C:\windows\Logs\Window_10_Setup"
                $logFilePath = "$logFileBasePath\$namespace.log"
                $logger = Get-Logger $namespace $logFilePath -NoMutex
                for ( $i = 0; $i -lt 1000; $i++ ) {
                    $logger.Info("Hello from $jobName, index: $i")
                }
                Write-Host "Job Arguments: Namespace: $namespace, JobName: $jobName"
                Write-Host "Logger.Namespace: $($logger.Namespace)"
            }
            $job1 = "Job1"
            $job2 = "Job2"

            Start-Job -ScriptBlock $jobScriptBlock -Name $job1 -ArgumentList $job1
            Start-Job -ScriptBlock $jobScriptBlock -Name $job2 -ArgumentList $job2
            Get-job | Wait-job | Receive-Job 
        }
        $testScriptBlock | Should throw
    }

    It "Wrting from parallel jobs to one file with mutex should not throw, and the count of lines should from each job be correct" {
        $testScriptBlock = {
            $jobScriptBlock = {
                param($jobName)
                $namespace = "ConcurrentBuildLogTest"
                $logFileBasePath = "C:\windows\Logs\Window_10_Setup"
                $logFilePath = "$logFileBasePath\$namespace.log"
                $logger = Get-Logger $namespace $logFilePath
                for ( $i = 0; $i -lt 1000; $i++ ) {
                    $logger.Info("Hello from $jobName, index: $i")
                }
                Write-Host "Job Arguments: Namespace: $namespace, JobName: $jobName"
                Write-Host "Logger.Namespace: $($logger.Namespace)"
            }

            0..9 | ForEach-Object {
                $job = "Job$_"
                Start-Job -ScriptBlock $jobScriptBlock -Name $job -ArgumentList $job
            }
            Get-job | Wait-job | Receive-Job
        }
        $testScriptBlock | Should Not throw
        # tried this as well - never throws
        # 1..10 | ForEach-Object {
        #     Write-Host "Attempt $_"
        #     $testScriptBlock | Should Not throw
        # }
        $lines = Get-Content $logFilePath
        0..9 | ForEach-Object {
            $job = "Job$_"
            $linesFiltered = $lines | Where-Object {$_.Contains($job)}
            $linesFiltered.Length | Should be 1000
        }      
    }
}