
$ErrorActionPreference="Continue"

Describe "Hardware Platform" {
    
    BeforeAll {
        try{
            $module = "HardwarePlatform"
            import-module -name $module
        }finally{
            remove-module -name $module
        }
    }

    AfterAll {
        remove-module -name $module
    }

    Context "Supported Hardware enum" {
        it "should be able to get the supported hardware" {
            [PanaceaImage.SupportedHardware]::Remedi.GetType().FullName | Should Be "PanaceaImage.SupportedHardware"
        }
    }

    Context "CreatePlatform" {

        it "Should be able to create a platform" {
            $type = [PanaceaImage.SupportedHardware]::Remedi
            $platform = CreatePlatform $type @("Audio1","Audio2")
            $platform.Type | Should be $type
            $platform.Devices | Should be @("Audio1","Audio2")
        }
    }

    Context "Get Platform" {
        BeforeAll {
            $platform = Get-Platform
        }


        it "should not be null" {
            $platform | Should not BeNullOrEmpty
        }

        it "should be of type Hardware" {
            write-host $platform.GetType()
        }

    }

    Context "Get Hardware Model" {
        it "should exist" {
            Get-HardWareModel | Should Not BeNullOrEmpty
        }

        it "should be equal to the wmi query" {
            $model  = Get-WmiObject -class Win32_Computersystem | Select -ExpandProperty model
            Get-HardWareModel | Should Be $model
        }
    }

    Context "Get Platform From Model" {

        it "Should be able to get the hardware platform" {
            $platform = Get-PlatformFromModel "Medi-Link 18.5 (REM-ML-EKAB-001)"
            $platform.Name | Should be "Remedi"
        }
    }


    Context "Get Platform using WMI" {


        BeforeAll {
            $platform = Get-Platform
        }
        it "Should be able to get the hardware platform" {
            $platform.Name.GetType().Name | Should Be "String"
        }
        
        
        it "Should be able to get the audio devices" {
            $platform.Devices.GetType().Name| Should be "String[]"
        }
    }




}