
<#
    This test proves that you can just use the @ parameter on an object and the properties will be passed to the function
#>


Describe "PowerShell Test Commands" {


    Context "using the @ parameter" {

        function Test {
            param(
                [string] $firstname,
                [string] $lastname,
                [string] $message
            )


            return "{0} {1}: {2}" -f $firstname, $lastname, $message
        }



        it "Should construct the sentence from @parameters" {
            $person = @{
                firstname = "Shav"
                lastname  = "G"
                message   = "Hello World"
            }


            $message = Test @person

            $message | Should Be "Shav G: Hello World"
        }

    }

    Context "Catching errors" {


        BeforeAll{
            import-module Utility
            $originalErrorActionPreference = $ErrorActionPreference
            $ErrorActionPreference="Stop"
        }

        AfterAll{
            $ErrorActionPreference=$originalErrorActionPreference;
            Remove-Module Utility
        }

        it "Should catch errors " {
            
            function Run {

                CatchError {
                    throw "Correct"
                } "LogMessage" -ErrorAction Stop
            }

            { Run }| Should throw "Correct"
        }

    }


}